/* ============================================================
  Configuration
============================================================ */
diameter_pipe        = 28; // 24
diameter_rope        = 4.25;
distance_pipe_rope   = 67.5;
wall                 = 8;
chamfer              = 3;
diameter_screw_inner = 3.2;
diameter_screw_outer = 9;
quality = 1;


height = diameter_pipe * 1.5;

/* ============================================================
  Code
============================================================ */

difference() {
  body();
  subtract();
}

/* ============================================================
  Modules
============================================================ */

module body() {

  minkowski() {
    
    hull() {
      // main pipe
      cylinder(
        d = diameter_pipe + wall * 4 - chamfer,
        h = height - chamfer,
        center = true
      );
      
      // hole for rope
      translate([0, distance_pipe_rope, - height * 0.25 + chamfer * 0.5])
      cylinder(
        d = diameter_rope + wall * 2,
        h = height * 0.5,
        center = true
      );
    }
    
    sphere(
      d = chamfer
    );
  }

}

module subtract() {

  // main pipe
  cylinder(
    d = diameter_pipe,
    h = height * 1.5,
    center = true,
    $fn = 64 * quality
  );

  // hole for rope
  translate([0, distance_pipe_rope, 0])
  cylinder(
    d = diameter_rope,
    h = height * 1.5,
    center = true,
    $fn = 16 * quality
  );
  
  // screws right
  translate([diameter_pipe * 0.5 + wall, 0, 10])
  screw_outer_hole();
  translate([diameter_pipe * 0.5 + wall, 0, -10])
  screw_outer_hole();
  
  // screws left
  translate([- (diameter_pipe * 0.5 + wall), 0, 10])
  screw_outer_hole();
  translate([- (diameter_pipe * 0.5 + wall), 0, -10])
  screw_outer_hole();
  
  // divider
  cube(
    [diameter_pipe * 3, 0.5, height * 1.5],
    center = true
  );

}

module screw_outer_hole() {
  
  rotate([90, 0, 0,])
  translate([0, 0, diameter_pipe * 0.25])
  cylinder(
    d = diameter_screw_outer,
    h = diameter_pipe * 2,
    $fn = 32 * quality
  );
  
  rotate([-90, 0, 0,])
  translate([0, 0, diameter_pipe * 0.25])
  cylinder(
    d = diameter_screw_outer,
    h = diameter_pipe * 3,
    $fn = 32 * quality
  );
  
  rotate([90, 0, 0])
  translate([0, 0, 0])
  cylinder(
    d = diameter_screw_inner,
    h = diameter_pipe * 2,
    center = true,
    $fn = 16 * quality
  );
}